/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.ifs.util.CSVFile;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class GetInfo {
    public static HashMap<String, String> getInfo(String comment) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(comment));
            String line = null;
            HashMap<String, String> info = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(58);
                if (idx < 0) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            reader.close();
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            return null;
        }
    }

    public static HashMap<String, String> getInfo(File outputFile) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(outputFile));
            String line = null;
            HashMap<String, String> info = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(44);
                if (idx < 0) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            reader.close();
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            return null;
        }
    }

    public static HashMap<String, String> getInfo(Element root) {
        try {
            HashMap<String, String> info = new HashMap<String, String>();
            Iterator i = root.elementIterator("property");
            while (i.hasNext()) {
                Element property = (Element)i.next();
                String key = property.attributeValue("name");
                String value = property.getText();
                if (key == null || value == null) continue;
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            return null;
        }
    }

    public static void getInfo(File folder, List<Info> infos, String prefix) {
        File solutionFile;
        File outputFile;
        HashMap<String, String> info;
        File infoFile = new File(folder, "info.xml");
        if (infoFile.exists()) {
            System.out.println("Reading " + infoFile + " ...");
            try {
                Document document = new SAXReader().read(infoFile);
                info = GetInfo.getInfo(document.getRootElement());
                if (info != null && !info.isEmpty()) {
                    infos.add(new Info(prefix, info));
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Error reading file " + infoFile + ", message: " + e.getMessage());
            }
        }
        if ((outputFile = new File(folder, "output.csv")).exists()) {
            System.out.println("Reading " + outputFile + " ...");
            try {
                info = GetInfo.getInfo(outputFile);
                if (info != null && !info.isEmpty()) {
                    infos.add(new Info(prefix, info));
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Error reading file " + infoFile + ", message: " + e.getMessage());
            }
        }
        if (!(solutionFile = new File(folder, "solution.xml")).exists()) {
            return;
        }
        try {
            System.out.println("Reading " + solutionFile + " ...");
            Document document = new SAXReader().read(solutionFile);
            Iterator i = document.nodeIterator();
            while (i.hasNext()) {
                HashMap<String, String> info2;
                Comment comment;
                Node node = (Node)i.next();
                if (!(node instanceof Comment) || (comment = (Comment)node).getText().indexOf("Solution Info:") < 0 || (info2 = GetInfo.getInfo(comment.getText())) == null) continue;
                infos.add(new Info(prefix, info2));
            }
        }
        catch (Exception e) {
            System.err.println("Error reading file " + solutionFile + ", message: " + e.getMessage());
        }
    }

    public static void getInfos(File folder, List<Info> infos, String prefix) {
        System.out.println("Checking " + folder + " ...");
        File[] files = folder.listFiles();
        GetInfo.getInfo(folder, infos, prefix == null ? "" : prefix);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            GetInfo.getInfos(files[i], infos, (prefix == null ? "" : prefix + "/") + files[i].getName());
        }
    }

    public static void writeInfos(List<Info> infos, File file) {
        try {
            System.out.println("Writing " + file + " ...");
            TreeSet<String> keys = new TreeSet<String>();
            ArrayList<CSVFile.CSVField> headers = new ArrayList<CSVFile.CSVField>();
            headers.add(new CSVFile.CSVField((Object)""));
            for (Info info : infos) {
                keys.addAll(info.getInfo().keySet());
                headers.add(new CSVFile.CSVField((Object)info.getPrefix()));
            }
            CSVFile csvFile = new CSVFile();
            csvFile.setHeader(headers);
            for (String key : keys) {
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField((Object)key));
                for (Info info : infos) {
                    String value = info.getInfo().get(key);
                    line.add(new CSVFile.CSVField((Object)(value == null ? "" : value)));
                }
                csvFile.addLine(line);
            }
            csvFile.save(file);
        }
        catch (Exception e) {
            System.err.println("Error writing file " + file + ", message: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            File folder = new File(args[0]);
            ArrayList<Info> infos = new ArrayList<Info>();
            GetInfo.getInfos(folder, infos, null);
            if (!infos.isEmpty()) {
                GetInfo.writeInfos(infos, new File(folder, "info.csv"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Info {
        private String iPrefix;
        private HashMap<String, String> iInfo;

        public Info(String prefix, HashMap<String, String> info) {
            this.iPrefix = prefix;
            this.iInfo = info;
        }

        public String getPrefix() {
            return this.iPrefix;
        }

        public Map<String, String> getInfo() {
            return this.iInfo;
        }
    }
}

