/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentOnlineConflict
extends StudentConflict {
    private String iOnlineRoom = null;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iOnlineRoom = properties.getProperty("StudentConflict.OnlineRoom", properties.getProperty("General.OnlineRoom", "(?i)ONLINE|"));
    }

    public boolean isOnline(Placement p) {
        if (p.getNrRooms() == 0) {
            return "".matches(this.iOnlineRoom);
        }
        if (p.getNrRooms() == 1) {
            return p.getRoomLocation().getName() != null && p.getRoomLocation().getName().matches(this.iOnlineRoom);
        }
        for (RoomLocation r : p.getRoomLocations()) {
            if (r.getName() != null && r.getName().matches(this.iOnlineRoom)) continue;
            return false;
        }
        return true;
    }

    public boolean shareDays(Placement p1, Placement p2) {
        return p1 != null && p2 != null && p1.getTimeLocation().shareDays(p2.getTimeLocation()) && p1.getTimeLocation().shareWeeks(p2.getTimeLocation());
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return p1 != null && p2 != null && this.isOnline(p1) != this.isOnline(p2) && this.shareDays(p1, p2);
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentOnlineConflict.ignore(l1, l2) && StudentOnlineConflict.applicable(l1, l2);
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.StudentOnlineConflictWeight", 0.5 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.StudentOnlineConflictWeight";
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            info.put("Student online conflicts", sDoubleFormat.format(conf));
        }
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            info.put("Student online conflicts", sDoubleFormat.format(conf));
        }
    }
}

