/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.additional.InstructorStudentHardConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorStudentConflict
extends StudentConflict {
    @Override
    protected double jointEnrollment(JenrlConstraint jenrl) {
        double ret = 0.0;
        for (Student student : jenrl.getInstructors()) {
            ret += student.getJenrlWeight((Lecture)jenrl.first(), (Lecture)jenrl.second());
        }
        return ret;
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !InstructorStudentConflict.ignore(l1, l2) && InstructorStudentConflict.applicable(l1, l2) && this.instructor(l1, l2);
    }

    public boolean instructor(Lecture l1, Lecture l2) {
        JenrlConstraint jenrl;
        JenrlConstraint jenrlConstraint = jenrl = l1 == null || l2 == null ? null : l1.jenrlConstraint(l2);
        if (jenrl == null) {
            return false;
        }
        return jenrl.getNrInstructors() > 0;
    }

    @Override
    public void incJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (this.isApplicable((Lecture)jenrl.first(), (Lecture)jenrl.second()) && this.inConflict((Placement)assignment.getValue(jenrl.first()), (Placement)assignment.getValue(jenrl.second())) && student.getInstructor() != null && (student.getInstructor().variables().contains(jenrl.first()) || student.getInstructor().variables().contains(jenrl.second()))) {
            this.inc(assignment, studentWeight);
        }
    }

    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.InstructorStudentConflictWeight", 10.0 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrInstructorStudConfsWeight";
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(InstructorStudentHardConflict.class);
            double hard = c == null ? 0.0 : c.getValue(assignment);
            info.put("Instructor student conflicts", sDoubleFormat.format(conf) + (hard > 0.0 ? " [hard: " + sDoubleFormat.format(hard) + "]" : ""));
        }
    }

    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(InstructorStudentHardConflict.class);
            double hard = c == null ? 0.0 : c.getValue(assignment, variables);
            info.put("Instructor student conflicts", sDoubleFormat.format(conf) + (hard > 0.0 ? " [hard: " + sDoubleFormat.format(hard) + "]" : ""));
        }
    }
}

