/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ToolBox;

public class MaxWeeksFlexibleConstraint
extends FlexibleConstraint {
    private int iMaxWeeks;
    private int iDayCode;

    public MaxWeeksFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_WEEKS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxWeeks = Integer.parseInt(matcher.group(2));
            this.iDayCode = Integer.parseInt(matcher.group(3));
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_WEEKS;
        }
    }

    public boolean isCorectDayOfWeek(Placement value) {
        return value != null && value.getTimeLocation() != null && (this.iDayCode == 0 || (this.iDayCode & value.getTimeLocation().getDayCode()) != 0);
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        return ((MaxWeeksFlexibleConstraintContext)this.getContext(assignment)).nrViolations(assignments, conflicts);
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard() || !this.isCorectDayOfWeek(value)) {
            return;
        }
        MaxWeeksFlexibleConstraintContext context = (MaxWeeksFlexibleConstraintContext)this.getContext(assignment);
        while (context.nrWeeks(value, conflicts) > this.iMaxWeeks) {
            Set<Lecture> candidates = context.candidates(value, conflicts);
            if (candidates == null) {
                return;
            }
            for (Lecture candidate : candidates) {
                Placement conflict = (Placement)assignment.getValue((Variable)candidate);
                if (conflict == null) continue;
                conflicts.add(conflict);
            }
        }
    }

    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!this.isHard() || !this.isCorectDayOfWeek(value)) {
            return false;
        }
        return ((MaxWeeksFlexibleConstraintContext)this.getContext(assignment)).nrWeeks(value, null) > this.iMaxWeeks;
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxWeeksFlexibleConstraintContext(assignment);
    }

    public class MaxWeeksFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private List<BitSet> iWeeks = null;
        private Set<Lecture>[] iWeekAssignments = null;

        public MaxWeeksFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            Criterion criterion;
            this.iWeeks = ((TimetableModel)MaxWeeksFlexibleConstraint.this.getModel()).getWeeks();
            this.iWeekAssignments = new Set[this.iWeeks.size()];
            for (int i = 0; i < this.iWeekAssignments.length; ++i) {
                this.iWeekAssignments[i] = new HashSet<Lecture>();
            }
            for (Lecture variable : MaxWeeksFlexibleConstraint.this.variables()) {
                Placement value = (Placement)assignment.getValue((Variable)variable);
                if (value == null || !MaxWeeksFlexibleConstraint.this.isCorectDayOfWeek(value)) continue;
                for (int i = 0; i < this.iWeeks.size(); ++i) {
                    if (!value.getTimeLocation().shareWeeks(this.iWeeks.get(i))) continue;
                    this.iWeekAssignments[i].add((Lecture)value.variable());
                }
            }
            if (!MaxWeeksFlexibleConstraint.this.isHard() && (criterion = MaxWeeksFlexibleConstraint.this.getModel().getCriterion(FlexibleConstraintCriterion.class)) != null) {
                double pref = this.nrViolations(null, null);
                this.iLastPreference = pref == 0.0 ? (double)(-Math.abs(MaxWeeksFlexibleConstraint.this.iPreference)) : (double)Math.abs(MaxWeeksFlexibleConstraint.this.iPreference) * pref;
                criterion.inc(assignment, this.iLastPreference);
            }
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            if (MaxWeeksFlexibleConstraint.this.isCorectDayOfWeek(value)) {
                for (int i = 0; i < this.iWeeks.size(); ++i) {
                    if (!value.getTimeLocation().shareWeeks(this.iWeeks.get(i))) continue;
                    this.iWeekAssignments[i].add((Lecture)value.variable());
                }
                this.updateCriterion(assignment);
            }
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            if (MaxWeeksFlexibleConstraint.this.isCorectDayOfWeek(value)) {
                for (int i = 0; i < this.iWeeks.size(); ++i) {
                    if (!value.getTimeLocation().shareWeeks(this.iWeeks.get(i))) continue;
                    this.iWeekAssignments[i].remove(value.variable());
                }
                this.updateCriterion(assignment);
            }
        }

        public int nrWeeks(Placement value, Set<Placement> conflicts) {
            int ret = 0;
            for (int i = 0; i < this.iWeeks.size(); ++i) {
                BitSet w = this.iWeeks.get(i);
                int cnt = this.iWeekAssignments[i].size();
                if (value != null) {
                    if (value.getTimeLocation().shareWeeks(w)) {
                        ++cnt;
                    }
                    if (this.iWeekAssignments[i].contains(value.variable())) {
                        --cnt;
                    }
                }
                if (conflicts != null) {
                    for (Placement conflict : conflicts) {
                        if (value != null && ((Lecture)conflict.variable()).equals(value.variable()) || !this.iWeekAssignments[i].contains(conflict.variable())) continue;
                        --cnt;
                    }
                }
                if (cnt <= 0) continue;
                ++ret;
            }
            return ret;
        }

        public Set<Lecture> candidates(Placement value, Set<Placement> conflicts) {
            int bestCnt = 0;
            ArrayList<Integer> bestWeeks = new ArrayList<Integer>();
            for (int i = 0; i < this.iWeeks.size(); ++i) {
                BitSet w = this.iWeeks.get(i);
                if (value.getTimeLocation().shareWeeks(w)) continue;
                int cnt = this.iWeekAssignments[i].size();
                if (this.iWeekAssignments[i].contains(value.variable())) {
                    --cnt;
                }
                for (Placement conflict : conflicts) {
                    if (((Lecture)conflict.variable()).equals(value.variable()) || !this.iWeekAssignments[i].contains(conflict.variable())) continue;
                    --cnt;
                }
                if (cnt <= 0) continue;
                if (bestWeeks.isEmpty() || bestCnt > cnt) {
                    bestWeeks.clear();
                    bestWeeks.add(i);
                    bestCnt = cnt;
                    continue;
                }
                if (bestCnt != cnt) continue;
                bestWeeks.add(i);
            }
            return bestWeeks.isEmpty() ? null : this.iWeekAssignments[(Integer)ToolBox.random(bestWeeks)];
        }

        public int nrViolations(HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            int weeks = 0;
            for (int i = 0; i < this.iWeeks.size(); ++i) {
                BitSet w = this.iWeeks.get(i);
                int cnt = this.iWeekAssignments[i].size();
                if (assignments != null) {
                    for (Map.Entry entry : assignments.entrySet()) {
                        if (MaxWeeksFlexibleConstraint.this.isCorectDayOfWeek((Placement)((Object)entry.getValue())) && ((Placement)((Object)entry.getValue())).getTimeLocation().shareWeeks(w)) {
                            ++cnt;
                        }
                        if (!this.iWeekAssignments[i].contains(entry.getKey())) continue;
                        --cnt;
                    }
                }
                if (conflicts != null) {
                    for (Placement placement : conflicts) {
                        if (assignments != null && assignments.containsKey(placement.variable()) || !this.iWeekAssignments[i].contains(placement.variable())) continue;
                        --cnt;
                    }
                }
                if (cnt <= 0) continue;
                ++weeks;
            }
            return weeks <= MaxWeeksFlexibleConstraint.this.iMaxWeeks ? 0 : weeks - MaxWeeksFlexibleConstraint.this.iMaxWeeks;
        }
    }
}

