/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.ToolBox;

public class MaxHalfDaysFlexibleConstraint
extends FlexibleConstraint {
    private int iMaxHalfDays;
    private int iNoonSlot = 144;

    public MaxHalfDaysFlexibleConstraint(Long id, String owner, String preference, String reference) {
        super(id, owner, preference, reference);
        Matcher matcher = Pattern.compile(FlexibleConstraint.FlexibleConstraintType.MAX_HALF_DAYS.getPattern()).matcher(reference);
        if (matcher.find()) {
            this.iMaxHalfDays = Integer.parseInt(matcher.group(2));
            this.iConstraintType = FlexibleConstraint.FlexibleConstraintType.MAX_HALF_DAYS;
        }
    }

    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        this.iNoonSlot = ((TimetableModel)model).getProperties().getPropertyInt("General.HalfDaySlot", this.iNoonSlot);
    }

    protected int getNrHalfDays() {
        return 2;
    }

    protected int getHalfDay(TimeLocation time) {
        return time.getStartSlot() < this.iNoonSlot ? 0 : 1;
    }

    @Override
    public double getNrViolations(Assignment<Lecture, Placement> assignment, Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        return ((MaxHalfDaysFlexibleConstraintContext)this.getContext(assignment)).nrViolations(assignments, conflicts);
    }

    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.isHard()) {
            return;
        }
        MaxHalfDaysFlexibleConstraintContext context = (MaxHalfDaysFlexibleConstraintContext)this.getContext(assignment);
        while (context.nrHalfDays(value, conflicts) > this.iMaxHalfDays) {
            Set<Lecture> candidates = context.candidates(value, conflicts);
            if (candidates == null) {
                conflicts.add(value);
                return;
            }
            for (Lecture candidate : candidates) {
                Placement conflict = (Placement)assignment.getValue((Variable)candidate);
                if (conflict == null) continue;
                conflicts.add(conflict);
            }
        }
    }

    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!this.isHard()) {
            return false;
        }
        return ((MaxHalfDaysFlexibleConstraintContext)this.getContext(assignment)).nrHalfDays(value, null) > this.iMaxHalfDays;
    }

    @Override
    public FlexibleConstraint.FlexibleConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MaxHalfDaysFlexibleConstraintContext(assignment);
    }

    public class MaxHalfDaysFlexibleConstraintContext
    extends FlexibleConstraint.FlexibleConstraintContext {
        private Map<BitSet, Set<Lecture>[]> iHalfWeekDayAssignments = null;
        private Set<Lecture>[] iHalfDayAssignments = null;

        public MaxHalfDaysFlexibleConstraintContext(Assignment<Lecture, Placement> assignment) {
            Criterion criterion;
            for (BitSet week : MaxHalfDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] halfDayAssignments = this.getHalfDayAssignments(week);
                for (Lecture variable : MaxHalfDaysFlexibleConstraint.this.variables()) {
                    Placement value = (Placement)assignment.getValue((Variable)variable);
                    if (value == null) continue;
                    for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                        if (!this.hasDay(week, i, value)) continue;
                        halfDayAssignments[i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())].add((Lecture)value.variable());
                    }
                }
            }
            if (!MaxHalfDaysFlexibleConstraint.this.isHard() && (criterion = MaxHalfDaysFlexibleConstraint.this.getModel().getCriterion(FlexibleConstraintCriterion.class)) != null) {
                double pref = this.nrViolations(null, null);
                this.iLastPreference = pref == 0.0 ? (double)(-Math.abs(MaxHalfDaysFlexibleConstraint.this.iPreference)) : (double)Math.abs(MaxHalfDaysFlexibleConstraint.this.iPreference) * pref;
                criterion.inc(assignment, this.iLastPreference);
            }
        }

        protected boolean hasDay(BitSet week, int dayOfWeek, Placement value) {
            if (value == null || value.getTimeLocation() == null) {
                return false;
            }
            if (MaxHalfDaysFlexibleConstraint.this.isPreciseDateComputation()) {
                return value.getTimeLocation().hasDate(dayOfWeek, week, MaxHalfDaysFlexibleConstraint.this.getDayOfWeekOffset());
            }
            if (week != null && !value.getTimeLocation().getWeekCode().intersects(week)) {
                return false;
            }
            return (value.getTimeLocation().getDayCode() & Constants.DAY_CODES[dayOfWeek]) != 0;
        }

        protected Set<Lecture>[] getHalfDayAssignments(BitSet week) {
            Set<Lecture>[] dayAssignments;
            if (week == null) {
                if (this.iHalfDayAssignments == null) {
                    this.iHalfDayAssignments = new Set[MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() * Constants.NR_DAYS];
                    for (int i = 0; i < this.iHalfDayAssignments.length; ++i) {
                        this.iHalfDayAssignments[i] = new HashSet<Lecture>();
                    }
                }
                return this.iHalfDayAssignments;
            }
            if (this.iHalfWeekDayAssignments == null) {
                this.iHalfWeekDayAssignments = new HashMap<BitSet, Set<Lecture>[]>();
            }
            if ((dayAssignments = this.iHalfWeekDayAssignments.get(week)) == null) {
                dayAssignments = new Set[MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() * Constants.NR_DAYS];
                for (int i = 0; i < dayAssignments.length; ++i) {
                    dayAssignments[i] = new HashSet<Lecture>();
                }
                this.iHalfWeekDayAssignments.put(week, dayAssignments);
            }
            return dayAssignments;
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (BitSet week : MaxHalfDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] halfDayAssignments = this.getHalfDayAssignments(week);
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if (!this.hasDay(week, i, value)) continue;
                    halfDayAssignments[i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())].add((Lecture)value.variable());
                }
            }
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement value) {
            for (BitSet week : MaxHalfDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] halfDayAssignments = this.getHalfDayAssignments(week);
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if (!this.hasDay(week, i, value)) continue;
                    halfDayAssignments[i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())].remove(value.variable());
                }
            }
            this.updateCriterion(assignment);
        }

        public int nrHalfDays(BitSet week, Placement value, Set<Placement> conflicts) {
            Set<Lecture>[] halfDayAssignments = this.getHalfDayAssignments(week);
            int ret = 0;
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < MaxHalfDaysFlexibleConstraint.this.getNrHalfDays(); ++j) {
                    int idx = i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + j;
                    int cnt = halfDayAssignments[idx].size();
                    if (value != null) {
                        if (this.hasDay(week, i, value) && j == MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())) {
                            ++cnt;
                        }
                        if (halfDayAssignments[idx].contains(value.variable())) {
                            --cnt;
                        }
                    }
                    if (conflicts != null) {
                        for (Placement conflict : conflicts) {
                            if (value != null && ((Lecture)conflict.variable()).equals(value.variable()) || !halfDayAssignments[idx].contains(conflict.variable())) continue;
                            --cnt;
                        }
                    }
                    if (cnt <= 0) continue;
                    ++ret;
                }
            }
            return ret;
        }

        public int nrHalfDays(Placement value, Set<Placement> conflicts) {
            int ret = 0;
            for (BitSet week : MaxHalfDaysFlexibleConstraint.this.getWeeks()) {
                int days = this.nrHalfDays(week, value, conflicts);
                if (days <= ret) continue;
                ret = days;
            }
            return ret;
        }

        public Set<Lecture> candidates(Placement value, Set<Placement> conflicts) {
            for (BitSet week : MaxHalfDaysFlexibleConstraint.this.getWeeks()) {
                Set<Lecture>[] halfDayAssignments = this.getHalfDayAssignments(week);
                int bestCnt = 0;
                int nrHalfDays = 0;
                ArrayList<Integer> bestHalfDays = new ArrayList<Integer>();
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    for (int j = 0; j < MaxHalfDaysFlexibleConstraint.this.getNrHalfDays(); ++j) {
                        int idx = i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + j;
                        if (this.hasDay(week, i, value) && j == MaxHalfDaysFlexibleConstraint.this.getHalfDay(value.getTimeLocation())) {
                            ++nrHalfDays;
                            continue;
                        }
                        int cnt = halfDayAssignments[idx].size();
                        if (halfDayAssignments[idx].contains(value.variable())) {
                            --cnt;
                        }
                        for (Placement conflict : conflicts) {
                            if (((Lecture)conflict.variable()).equals(value.variable()) || !halfDayAssignments[idx].contains(conflict.variable())) continue;
                            --cnt;
                        }
                        if (cnt <= 0) continue;
                        ++nrHalfDays;
                        if (bestHalfDays.isEmpty() || bestCnt > cnt) {
                            bestHalfDays.clear();
                            bestHalfDays.add(idx);
                            bestCnt = cnt;
                            continue;
                        }
                        if (bestCnt != cnt) continue;
                        bestHalfDays.add(idx);
                    }
                }
                if (bestHalfDays.isEmpty() || nrHalfDays <= MaxHalfDaysFlexibleConstraint.this.iMaxHalfDays) continue;
                return halfDayAssignments[(Integer)ToolBox.random(bestHalfDays)];
            }
            return null;
        }

        public int nrViolations(BitSet week, HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            Set<Lecture>[] halfDayAssignments = this.getHalfDayAssignments(week);
            int halfDays = 0;
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < MaxHalfDaysFlexibleConstraint.this.getNrHalfDays(); ++j) {
                    int idx = i * MaxHalfDaysFlexibleConstraint.this.getNrHalfDays() + j;
                    int cnt = halfDayAssignments[idx].size();
                    if (assignments != null) {
                        for (Map.Entry entry : assignments.entrySet()) {
                            Placement assignment = (Placement)((Object)entry.getValue());
                            if (assignment == null || !this.hasDay(week, i, assignment) || j != MaxHalfDaysFlexibleConstraint.this.getHalfDay(assignment.getTimeLocation())) continue;
                            ++cnt;
                        }
                    }
                    if (conflicts != null) {
                        for (Placement placement : conflicts) {
                            if (assignments != null && assignments.containsKey(placement.variable()) || !halfDayAssignments[idx].contains(placement.variable())) continue;
                            --cnt;
                        }
                    }
                    if (cnt <= 0) continue;
                    ++halfDays;
                }
            }
            return halfDays <= MaxHalfDaysFlexibleConstraint.this.iMaxHalfDays ? 0 : halfDays - MaxHalfDaysFlexibleConstraint.this.iMaxHalfDays;
        }

        public int nrViolations(HashMap<Lecture, Placement> assignments, Set<Placement> conflicts) {
            int ret = 0;
            for (BitSet week : MaxHalfDaysFlexibleConstraint.this.getWeeks()) {
                ret += this.nrViolations(week, assignments, conflicts);
            }
            return ret;
        }
    }
}

