/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;

public class ExamInstructor
extends Constraint<Exam, ExamPlacement> {
    private String iName;
    private boolean iAllowDirectConflicts = true;
    private List<ExamOwner> iOwners = new ArrayList<ExamOwner>();
    private boolean[] iAvailable = null;

    public ExamInstructor(ExamModel model, long id, String name) {
        this.iAllowDirectConflicts = model.getProperties().getPropertyBoolean("Instructor.AllowDirectConflicts", this.iAllowDirectConflicts);
        this.iId = id;
        this.iName = name;
        this.setModel((Model)model);
    }

    public boolean isAllowDirectConflicts() {
        return this.iAllowDirectConflicts;
    }

    public void setAllowDirectConflicts(boolean allowDirectConflicts) {
        this.iAllowDirectConflicts = allowDirectConflicts;
    }

    public Set<Exam> getExams(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        HashSet exams = ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, period).get((Object)this);
        return exams != null ? exams : new HashSet();
    }

    public Set<Exam> getExamsADay(Assignment<Exam, ExamPlacement> assignment, ExamPeriod period) {
        HashSet exams = ((ExamModel)this.getModel()).getInstructorsOfDay(assignment, period).get((Object)this);
        return exams != null ? exams : new HashSet();
    }

    public Set<Exam> getExamsADay(Assignment<Exam, ExamPlacement> assignment, int day) {
        HashSet exams = ((ExamModel)this.getModel()).getInstructorsOfDay(assignment, day).get((Object)this);
        return exams != null ? exams : new HashSet();
    }

    public void computeConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p, Set<ExamPlacement> conflicts) {
        if (this.isAllowDirectConflicts()) {
            return;
        }
        Set<Exam> exams = ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, p.getPeriod()).get((Object)this);
        if (exams != null) {
            for (Exam exam : exams) {
                conflicts.add((ExamPlacement)assignment.getValue((Variable)exam));
            }
        }
    }

    public boolean inConflict(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p) {
        if (this.isAllowDirectConflicts()) {
            return false;
        }
        Set<Exam> exams = ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, p.getPeriod()).get((Object)this);
        return exams != null && !exams.isEmpty();
    }

    public boolean isConsistent(ExamPlacement p1, ExamPlacement p2) {
        if (this.isAllowDirectConflicts()) {
            return true;
        }
        return p1.getPeriod() != p2.getPeriod();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamInstructor)) {
            return false;
        }
        ExamInstructor s = (ExamInstructor)((Object)o);
        return this.getId() == s.getId();
    }

    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    public String getName() {
        return this.hasName() ? this.iName : String.valueOf(this.getId());
    }

    public boolean hasName() {
        return this.iName != null && this.iName.length() > 0;
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(ExamInstructor o) {
        return this.toString().compareTo(o.toString());
    }

    public List<ExamOwner> getOwners() {
        return this.iOwners;
    }

    public boolean isHard() {
        return !this.isAllowDirectConflicts();
    }

    public boolean isAvailable(ExamPeriod period) {
        return this.iAvailable == null ? true : this.iAvailable[period.getIndex()];
    }

    public void setAvailable(int period, boolean available) {
        if (this.iAvailable == null) {
            this.iAvailable = new boolean[((ExamModel)this.getModel()).getNrPeriods()];
            for (int i = 0; i < this.iAvailable.length; ++i) {
                this.iAvailable[i] = true;
            }
        }
        this.iAvailable[period] = available;
    }

    public boolean canConflict(Exam ex1, Exam ex2) {
        return this.isAllowDirectConflicts() && ex1.isAllowDirectConflicts() && ex2.isAllowDirectConflicts();
    }
}

