/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningXMLLoader;
import org.cpsolver.studentsct.StudentSectioningXMLSaver;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class Solution2Expectations {
    private static Logger sLog = LogManager.getLogger(Solution2Expectations.class);

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            DataProperties config = new DataProperties();
            String command = args[0];
            if ("real2exp".equals(command)) {
                StudentSectioningModel model = new StudentSectioningModel(config);
                DefaultSingleAssignment assignment = new DefaultSingleAssignment();
                StudentSectioningXMLLoader loader = new StudentSectioningXMLLoader(model, (Assignment<Request, Enrollment>)assignment);
                loader.setInputFile(new File(args[1]));
                loader.load();
                sLog.info("Loaded: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
                for (Student s : model.getStudents()) {
                    s.setDummy(true);
                }
                model.computeOnlineSectioningInfos((Assignment<Request, Enrollment>)assignment);
                for (Student s : model.getStudents()) {
                    s.setDummy(false);
                }
                for (Request request : model.variables()) {
                    assignment.unassign(0L, (Variable)request);
                }
                Solution solution = new Solution((Model)model, (Assignment)assignment, 0L, 0.0);
                Solver solver = new Solver(config);
                solver.setInitalSolution(solution);
                new StudentSectioningXMLSaver((Solver<Request, Enrollment>)solver).save(new File(args[2]));
                sLog.info("Saved: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
            } else if ("ll2exp".equals(command)) {
                StudentSectioningModel model = new StudentSectioningModel(config);
                DefaultSingleAssignment assignment = new DefaultSingleAssignment();
                StudentSectioningXMLLoader loader = new StudentSectioningXMLLoader(model, (Assignment<Request, Enrollment>)assignment);
                loader.setInputFile(new File(args[1]));
                loader.load();
                sLog.info("Loaded: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
                model.computeOnlineSectioningInfos((Assignment<Request, Enrollment>)assignment);
                for (Request request : model.variables()) {
                    assignment.unassign(0L, (Variable)request);
                }
                Solution solution = new Solution((Model)model, (Assignment)assignment, 0L, 0.0);
                Solver solver = new Solver(config);
                solver.setInitalSolution(solution);
                new StudentSectioningXMLSaver((Solver<Request, Enrollment>)solver).save(new File(args[2]));
                sLog.info("Saved: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
            } else if ("students".equals(command)) {
                StudentSectioningModel model = new StudentSectioningModel(config);
                DefaultSingleAssignment assignment = new DefaultSingleAssignment();
                StudentSectioningXMLLoader loader = new StudentSectioningXMLLoader(model, (Assignment<Request, Enrollment>)assignment);
                loader.setInputFile(new File(args[1]));
                loader.setLoadStudents(false);
                loader.load();
                sLog.info("Loaded [1]: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
                StudentSectioningXMLLoader loder2 = new StudentSectioningXMLLoader(model, (Assignment<Request, Enrollment>)assignment);
                loder2.setInputFile(new File(args[2]));
                loder2.setLoadOfferings(false);
                loder2.setLoadStudents(true);
                loder2.load();
                sLog.info("Loaded [2]: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
                Solution solution = new Solution((Model)model, (Assignment)assignment, 0L, 0.0);
                Solver solver = new Solver(config);
                solver.setInitalSolution(solution);
                new StudentSectioningXMLSaver((Solver<Request, Enrollment>)solver).save(new File(args[3]));
                sLog.info("Saved [3]: " + ToolBox.dict2string(model.getExtendedInfo((Assignment<Request, Enrollment>)assignment), (int)2));
            } else {
                sLog.error("Unknown command: " + command);
            }
        }
        catch (Exception e) {
            sLog.error(e.getMessage(), (Throwable)e);
        }
    }
}

