/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.exam.heuristics.ExamColoringConstruction;
import org.cpsolver.exam.heuristics.ExamConstruction;
import org.cpsolver.exam.heuristics.ExamTabuSearch;
import org.cpsolver.exam.heuristics.ExamUnassignedVariableSelection;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.neighbours.ExamPeriodSwapMove;
import org.cpsolver.exam.neighbours.ExamRandomMove;
import org.cpsolver.exam.neighbours.ExamRoomMove;
import org.cpsolver.exam.neighbours.ExamTimeMove;
import org.cpsolver.ifs.algorithms.GreatDeluge;
import org.cpsolver.ifs.algorithms.HillClimber;
import org.cpsolver.ifs.algorithms.SimulatedAnnealing;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;

public class ExamNeighbourSelection
extends NeighbourSelectionWithContext<Exam, ExamPlacement, Context>
implements TerminationCondition<Exam, ExamPlacement> {
    private static Logger sLog = LogManager.getLogger(ExamNeighbourSelection.class);
    private ExamColoringConstruction iColor = null;
    private ExamConstruction iCon = null;
    private StandardNeighbourSelection<Exam, ExamPlacement> iStd = null;
    private SimulatedAnnealing<Exam, ExamPlacement> iSA = null;
    private HillClimber<Exam, ExamPlacement> iHC = null;
    private HillClimber<Exam, ExamPlacement> iFin = null;
    private GreatDeluge<Exam, ExamPlacement> iGD = null;
    private boolean iUseGD = false;
    private Progress iProgress = null;
    private Callback iFinalPhaseFinished = null;
    private TerminationCondition<Exam, ExamPlacement> iTerm = null;
    private boolean iFinalPhase = false;

    public ExamNeighbourSelection(DataProperties properties) {
        if (properties.getPropertyBoolean("Exam.ColoringConstruction", false)) {
            this.iColor = new ExamColoringConstruction(properties);
        }
        this.iCon = new ExamConstruction(properties);
        try {
            this.iStd = new StandardNeighbourSelection(properties);
            this.iStd.setVariableSelection((VariableSelection)new ExamUnassignedVariableSelection(properties));
            this.iStd.setValueSelection((ValueSelection)new ExamTabuSearch(properties));
        }
        catch (Exception e) {
            sLog.error("Unable to initialize standard selection, reason: " + e.getMessage(), (Throwable)e);
            this.iStd = null;
        }
        properties.setProperty("SimulatedAnnealing.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName() + ";" + ExamPeriodSwapMove.class.getName());
        this.iSA = new SimulatedAnnealing(properties);
        properties.setProperty("HillClimber.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName() + ";" + ExamPeriodSwapMove.class.getName());
        this.iHC = new HillClimber(properties);
        this.iFin = new HillClimber(properties);
        this.iFin.setPhase("Finalization");
        properties.setProperty("GreatDeluge.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName() + ";" + ExamPeriodSwapMove.class.getName());
        this.iGD = new GreatDeluge(properties);
        this.iUseGD = properties.getPropertyBoolean("Exam.GreatDeluge", this.iUseGD);
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
        super.init(solver);
        if (this.iColor != null) {
            this.iColor.init(solver);
        }
        this.iCon.init(solver);
        this.iStd.init(solver);
        this.iSA.init(solver);
        this.iHC.init(solver);
        this.iFin.init(solver);
        this.iGD.init(solver);
        if (this.iTerm == null) {
            this.iTerm = solver.getTerminationCondition();
            solver.setTerminalCondition((TerminationCondition)this);
        }
        this.iFinalPhase = false;
        this.iProgress = Progress.getInstance((Object)solver.currentSolution().getModel());
    }

    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Neighbour n = null;
        if (!this.isFinalPhase() && !this.iTerm.canContinue(solution)) {
            this.setFinalPhase(null);
        }
        Context phase = (Context)this.getContext(solution.getAssignment());
        if (this.isFinalPhase()) {
            phase.setPhase(9999);
        }
        switch (phase.getPhase()) {
            case -1: {
                phase.setPhase(0);
                sLog.info("***** construction phase *****");
                if (this.iColor != null && (n = this.iColor.selectNeighbour(solution)) != null) {
                    return n;
                }
            }
            case 0: {
                n = this.iCon.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                if (solution.getAssignment().nrAssignedVariables() > 0) {
                    this.iProgress.setPhase("Searching for initial solution...", (long)solution.getModel().variables().size());
                }
                phase.setPhase(1);
                sLog.info("***** cbs/tabu-search phase *****");
            }
            case 1: {
                if (this.iStd != null && solution.getModel().variables().size() > solution.getAssignment().nrAssignedVariables()) {
                    this.iProgress.setProgress((long)(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables()));
                    n = this.iStd.selectNeighbour(solution);
                    if (n != null) {
                        return n;
                    }
                }
                phase.setPhase(2);
                sLog.info("***** hill climbing phase *****");
            }
            case 2: {
                n = this.iHC.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                phase.setPhase(3);
                sLog.info("***** " + (this.iUseGD ? "great deluge" : "simulated annealing") + " phase *****");
            }
            case 3: {
                if (this.iUseGD) {
                    return this.iGD.selectNeighbour(solution);
                }
                return this.iSA.selectNeighbour(solution);
            }
            case 9999: {
                n = this.iFin.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                phase.setPhase(-1);
                if (this.iFinalPhaseFinished != null && this.iTerm.canContinue(solution)) {
                    this.iFinalPhaseFinished.execute();
                }
                phase.setCanContinue(false);
            }
        }
        return null;
    }

    public void setFinalPhase(Callback finalPhaseFinished) {
        sLog.info("***** final phase *****");
        this.iFinalPhaseFinished = finalPhaseFinished;
        this.iFinalPhase = true;
    }

    public boolean isFinalPhase() {
        return this.iFinalPhase;
    }

    public boolean canContinue(Solution<Exam, ExamPlacement> currentSolution) {
        return ((Context)this.getContext(currentSolution.getAssignment())).isCanContinue();
    }

    public Context createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new Context();
    }

    public class Context
    implements AssignmentContext {
        private int iPhase = -1;
        private boolean iCanContinue = true;

        public int getPhase() {
            return this.iPhase;
        }

        public void setPhase(int phase) {
            this.iPhase = phase;
        }

        public boolean isCanContinue() {
            return this.iCanContinue;
        }

        public void setCanContinue(boolean canContinue) {
            this.iCanContinue = canContinue;
        }
    }
}

