/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.reservation.Reservation;

public class DisabledSections
extends GlobalConstraint<Request, Enrollment> {
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (this.inConflict(assignment, enrollment)) {
            conflicts.add(enrollment);
        }
    }

    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        if (enrollment.getStudent().isAllowDisabled()) {
            return false;
        }
        boolean hasDisabledSection = false;
        for (Section section : enrollment.getSections()) {
            if (section.isEnabled(enrollment.getStudent())) continue;
            hasDisabledSection = true;
            break;
        }
        if (!hasDisabledSection) {
            return false;
        }
        if (!config.getOffering().hasReservations()) {
            return true;
        }
        Reservation reservation = enrollment.getReservation();
        if (reservation != null && reservation.isAllowDisabled()) {
            return false;
        }
        for (Reservation r : config.getOffering().getReservations()) {
            if (!r.isAllowDisabled() || !r.isApplicable(enrollment.getStudent()) || !r.isIncluded(enrollment)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "DisabledSections";
    }
}

