/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentMoreThan2ADayConflicts
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.MoreThanTwoADayWeight";
    }

    public double getWeightDefault(DataProperties config) {
        return 100.0;
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        Map<ExamStudent, Set<Exam>> students = ((ExamModel)this.getModel()).getStudentsOfDay(assignment, period);
        for (ExamStudent s : exam.getStudents()) {
            int nrExams;
            Set<Exam> exams = students.get((Object)s);
            if (exams == null || exams.size() < 2 || (nrExams = exams.size() + (exams.contains((Object)exam) ? 0 : 1)) <= 2) continue;
            ++penalty;
        }
        return penalty;
    }

    public String getName() {
        return "More Than 2 A Day Conflicts";
    }

    @Override
    public String getXmlWeightName() {
        return "moreThanTwoADayWeight";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment)));
        }
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        int ret = 0;
        ExamModel m = (ExamModel)this.getModel();
        HashSet<Integer> days = new HashSet<Integer>();
        for (ExamPeriod p : m.getPeriods()) {
            if (!days.add(p.getDay())) continue;
            Map<ExamStudent, Set<Exam>> students = ((ExamModel)this.getModel()).getStudentsOfDay(assignment, p);
            for (Set<Exam> exams : students.values()) {
                int nrExams = exams.size();
                if (nrExams <= 2) continue;
                ret += nrExams - 2;
            }
        }
        return ret;
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "M2D:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

