/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class ShuffleStudentsSelection
implements NeighbourSelection<Request, Enrollment> {
    private Queue<Shuffle> iQueue = null;
    private ShuffleBacktrackNeighbourSelection iBacktrack;

    public ShuffleStudentsSelection(DataProperties properties) {
    }

    public void init(Solver<Request, Enrollment> solver) {
        StudentSectioningModel model = (StudentSectioningModel)solver.currentSolution().getModel();
        this.iQueue = new LinkedList<Shuffle>();
        Assignment assignment = solver.currentSolution().getAssignment();
        RouletteWheelSelection groups = new RouletteWheelSelection();
        for (Offering offering : model.getOfferings()) {
            if (offering.isDummy()) continue;
            for (Course course : offering.getCourses()) {
                for (Object group : course.getRequestGroups()) {
                    double spread = group.getAverageSpread((Assignment<Request, Enrollment>)solver.currentSolution().getAssignment());
                    if (spread >= 1.0) continue;
                    groups.add(group, 1.0 - spread);
                }
            }
        }
        if (groups.hasMoreElements()) {
            RequestGroup group = (RequestGroup)((Object)groups.nextElement());
            RouletteWheelSelection subparts = new RouletteWheelSelection();
            for (CourseRequest cr : group.getRequests()) {
                Object e = (Enrollment)assignment.getValue((Variable)cr);
                if (e == null) continue;
                for (Section section : e.getSections()) {
                    if (!(group.getSectionSpread((Assignment<Request, Enrollment>)assignment, section) < 1.0)) continue;
                    subparts.addExisting((Object)section.getSubpart(), 1.0);
                }
            }
            if (subparts.hasMoreElements()) {
                Subpart subpart = (Subpart)subparts.nextElement();
                RouletteWheelSelection sections = new RouletteWheelSelection();
                block7: for (Section section : subpart.getSections()) {
                    for (CourseRequest courseRequest : group.getRequests()) {
                        boolean match = false;
                        for (Enrollment e : courseRequest.values((Assignment<Request, Enrollment>)assignment)) {
                            if (!e.getSections().contains(section)) continue;
                            match = true;
                            break;
                        }
                        if (match) continue;
                        continue block7;
                    }
                    int nrConflicts = 0;
                    if (!section.isAllowOverlap()) {
                        block10: for (CourseRequest cr2 : group.getRequests()) {
                            for (Request r : cr2.getStudent().getRequests()) {
                                Enrollment e;
                                if (r.equals((Object)cr2) || (e = (Enrollment)assignment.getValue((Variable)r)) == null || e.isAllowOverlap() || !section.isOverlapping(e.getSections())) continue;
                                ++nrConflicts;
                                continue block10;
                            }
                        }
                    }
                    sections.add((Object)section, (double)(1 + group.getRequests().size() - nrConflicts));
                }
                HashSet<Section> filter = new HashSet<Section>();
                double space = 0.0;
                while (sections.hasMoreElements()) {
                    Section section = (Section)sections.nextElement();
                    if (filter.add(section)) {
                        if (section.getLimit() < 0) break;
                        space += (double)section.getLimit();
                    }
                    if (!(space >= group.getTotalWeight())) continue;
                    break;
                }
                for (CourseRequest cr : group.getRequests()) {
                    Enrollment e;
                    Shuffle shuffle = new Shuffle(group, cr, filter);
                    e = (Enrollment)assignment.getValue((Variable)cr);
                    if (e != null && shuffle.matchFilter(e)) continue;
                    this.iQueue.add(shuffle);
                }
            } else {
                for (CourseRequest cr : group.getRequests()) {
                    this.iQueue.add(new Shuffle(group, cr, null));
                }
            }
        }
        Collections.shuffle((LinkedList)this.iQueue);
        if (this.iBacktrack == null) {
            try {
                this.iBacktrack = new ShuffleBacktrackNeighbourSelection(solver.getProperties());
                this.iBacktrack.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase("Shuffling students along request groups...", (long)this.iQueue.size());
    }

    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Shuffle shuffle = null;
        while ((shuffle = this.iQueue.poll()) != null) {
            Progress.getInstance((Object)solution.getModel()).incProgress();
            Neighbour<Request, Enrollment> n = this.iBacktrack.selectNeighbour(solution, shuffle);
            if (n != null) {
                return n;
            }
            ArrayList<Enrollment> adepts = new ArrayList<Enrollment>();
            for (Enrollment e : shuffle.getRequest().values((Assignment<Request, Enrollment>)solution.getAssignment())) {
                if (!shuffle.matchFilter(e)) continue;
                adepts.add(e);
            }
            if (adepts.isEmpty()) continue;
            return new SimpleNeighbour((Variable)shuffle.getRequest(), (Value)ToolBox.random(adepts));
        }
        return null;
    }

    public static class ShuffleBacktrackNeighbourSelection
    extends BacktrackNeighbourSelection<Request, Enrollment> {
        ShuffleBacktrackNeighbourSelection(DataProperties properties) throws Exception {
            super(properties);
            this.setTimeout(properties.getPropertyInt("Shuffle.BackTrackTimeout", this.getTimeout()));
            this.setDepth(properties.getPropertyInt("Shuffle.BackTrackDepth", this.getDepth()));
            this.setMaxIters(properties.getPropertyInt("Shuffle.BackTrackMaxIters", this.getMaxIters()));
        }

        protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
            Shuffle shuffle = ((ShuffleBacktrackNeighbourSelectionContext)context).getShuffle();
            if (shuffle.matchRequest(variable) && shuffle.hasFilter()) {
                ArrayList<Enrollment> values = new ArrayList<Enrollment>();
                Iterator i = super.values(context, (Variable)variable);
                while (i.hasNext()) {
                    Enrollment e = (Enrollment)((Object)i.next());
                    if (!shuffle.matchFilter(e)) continue;
                    values.add(e);
                }
                return values.iterator();
            }
            return super.values(context, (Variable)variable);
        }

        protected Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution, Shuffle shuffle) {
            ShuffleBacktrackNeighbourSelectionContext context = new ShuffleBacktrackNeighbourSelectionContext(solution, shuffle);
            this.selectNeighbour(solution, (Variable)shuffle.getRequest(), context);
            return context.getBackTrackNeighbour();
        }

        private class ShuffleBacktrackNeighbourSelectionContext
        extends BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext {
            private Shuffle iShuffle;

            private ShuffleBacktrackNeighbourSelectionContext(Solution<Request, Enrollment> solution, Shuffle shuffle) {
                super((BacktrackNeighbourSelection)ShuffleBacktrackNeighbourSelection.this, solution);
                this.iShuffle = null;
                this.iShuffle = shuffle;
            }

            private Shuffle getShuffle() {
                return this.iShuffle;
            }
        }
    }

    private static class Shuffle {
        RequestGroup iGroup;
        CourseRequest iRequest;
        Set<Section> iFilter;

        Shuffle(RequestGroup group, CourseRequest request, Set<Section> filter) {
            this.iGroup = group;
            this.iRequest = request;
            this.iFilter = filter;
        }

        public CourseRequest getRequest() {
            return this.iRequest;
        }

        public boolean hasFilter() {
            return this.iFilter != null && !this.iFilter.isEmpty();
        }

        public boolean matchRequest(Request variable) {
            return variable instanceof CourseRequest && ((CourseRequest)variable).getCourses().contains((Object)this.iGroup.getCourse());
        }

        public boolean matchFilter(Enrollment e) {
            if (this.iFilter == null || this.iFilter.isEmpty()) {
                return true;
            }
            for (Section s : e.getSections()) {
                if (!this.iFilter.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

