/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.InstructorDirectConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;

public class InstructorNotAvailableConflicts
extends InstructorDirectConflicts {
    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamInstructor s : exam.getInstructors()) {
            if (s.isAvailable(value.getPeriod())) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> exams) {
        double ret = 0.0;
        for (Exam exam : exams) {
            ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
            if (placement == null) continue;
            ret += this.getValue(assignment, placement, null);
        }
        return ret;
    }

    @Override
    public String getName() {
        return "Instructor Not Available Conflicts";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "iNA:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

