/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class RandomUnassignmentSelection
implements NeighbourSelection<Request, Enrollment> {
    private List<Student> iStudents = null;
    protected double iRandom = 0.5;
    private Request.RequestPriority iPriority;

    public RandomUnassignmentSelection(DataProperties properties, Request.RequestPriority priority) {
        this.iRandom = properties.getPropertyDouble("Neighbour.RandomUnassignmentProb", this.iRandom);
        this.iPriority = priority;
    }

    public RandomUnassignmentSelection(DataProperties properties) {
        this(properties, Request.RequestPriority.Important);
    }

    public void init(Solver<Request, Enrollment> solver) {
        this.iStudents = ((StudentSectioningModel)solver.currentSolution().getModel()).getStudents();
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase("Random unassignment...", 1L);
    }

    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (Math.random() < this.iRandom) {
            Student student = (Student)ToolBox.random(this.iStudents);
            return new UnassignStudentNeighbour(student, (Assignment<Request, Enrollment>)solution.getAssignment(), this.iPriority);
        }
        Progress.getInstance((Object)solution.getModel()).incProgress();
        return null;
    }

    public static class UnassignStudentNeighbour
    implements Neighbour<Request, Enrollment> {
        private Student iStudent = null;
        private List<Request> iRequests = new ArrayList<Request>();
        private Request.RequestPriority iPriority;

        public UnassignStudentNeighbour(Student student, Assignment<Request, Enrollment> assignment, Request.RequestPriority priority) {
            Enrollment enrollment;
            this.iStudent = student;
            this.iPriority = priority;
            float credit = 0.0f;
            for (Request request : this.iStudent.getRequests()) {
                enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (this.canUnassign(enrollment)) {
                    this.iRequests.add(request);
                    continue;
                }
                if (enrollment == null) continue;
                credit += enrollment.getCredit();
            }
            if (credit < this.iStudent.getMinCredit()) {
                Iterator<Request> i = this.iRequests.iterator();
                while (i.hasNext()) {
                    Request request;
                    request = i.next();
                    enrollment = (Enrollment)assignment.getValue((Variable)request);
                    if (enrollment != null && enrollment.getCredit() > 0.0f) {
                        credit += enrollment.getCredit();
                        i.remove();
                    }
                    if (!(credit >= this.iStudent.getMaxCredit())) continue;
                    break;
                }
            }
        }

        public boolean canUnassign(Enrollment enrollment) {
            if (enrollment == null) {
                return false;
            }
            if (enrollment.getRequest().isMPP() && enrollment.equals(enrollment.getRequest().getInitialAssignment())) {
                return false;
            }
            if (enrollment.getStudent().getPriority().ordinal() < Student.StudentPriority.Normal.ordinal()) {
                return false;
            }
            return !this.iPriority.isCritical(enrollment.getRequest());
        }

        public double value(Assignment<Request, Enrollment> assignment) {
            double val = 0.0;
            for (Request request : this.iRequests) {
                Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (enrollment == null) continue;
                val -= enrollment.toDouble(assignment);
            }
            return val;
        }

        public void assign(Assignment<Request, Enrollment> assignment, long iteration) {
            for (Request request : this.iRequests) {
                assignment.unassign(iteration, (Variable)request);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Un{");
            sb.append(" " + this.iStudent);
            sb.append(" }");
            return sb.toString();
        }

        public Map<Request, Enrollment> assignments() {
            HashMap<Request, Enrollment> ret = new HashMap<Request, Enrollment>();
            for (Request request : this.iRequests) {
                ret.put(request, null);
            }
            return ret;
        }
    }
}

