/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.text.DecimalFormat;
import java.util.List;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamStudentMoreTwoADay {
    private ExamModel iModel = null;

    public ExamStudentMoreTwoADay(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Exam 1"), new CSVFile.CSVField((Object)"Enrl 1"), new CSVFile.CSVField((Object)"Period 1"), new CSVFile.CSVField((Object)"Date 1"), new CSVFile.CSVField((Object)"Time 1"), new CSVFile.CSVField((Object)"Exam 2"), new CSVFile.CSVField((Object)"Enrl 2"), new CSVFile.CSVField((Object)"Period 2"), new CSVFile.CSVField((Object)"Time 2"), new CSVFile.CSVField((Object)"Exam 3"), new CSVFile.CSVField((Object)"Enrl 3"), new CSVFile.CSVField((Object)"Period 3"), new CSVFile.CSVField((Object)"Time 3"), new CSVFile.CSVField((Object)"More-2-Day"), new CSVFile.CSVField((Object)"More-2-Day [%]")});
        DecimalFormat df = new DecimalFormat("0.0");
        for (Exam ex1 : this.iModel.variables()) {
            ExamPlacement p1 = (ExamPlacement)assignment.getValue((Variable)ex1);
            if (p1 == null) continue;
            for (Exam ex2 : this.iModel.variables()) {
                List<ExamStudent> students;
                ExamPlacement p2;
                if (ex2.equals((Object)ex1) || (p2 = (ExamPlacement)assignment.getValue((Variable)ex2)) == null || p2.getPeriod().getDay() != p1.getPeriod().getDay() || p2.getPeriod().getIndex() < p1.getPeriod().getIndex() || p1.getPeriod().equals(p2.getPeriod()) && ex1.getId() >= ex2.getId() || (students = ex1.getJointEnrollments().get((Object)ex2)) == null || students.isEmpty()) continue;
                for (Exam ex3 : this.iModel.variables()) {
                    ExamPlacement p3;
                    if (ex3.equals((Object)ex2) || ex3.equals((Object)ex1) || (p3 = (ExamPlacement)assignment.getValue((Variable)ex3)) == null || p3.getPeriod().getDay() != p2.getPeriod().getDay() || p3.getPeriod().getIndex() < p2.getPeriod().getIndex() || p1.getPeriod().equals(p3.getPeriod()) && ex1.getId() >= ex3.getId() || p2.getPeriod().equals(p3.getPeriod()) && ex2.getId() >= ex3.getId()) continue;
                    int m2d = 0;
                    for (ExamStudent h : ex3.getStudents()) {
                        if (!students.contains((Object)h)) continue;
                        ++m2d;
                    }
                    if (m2d == 0) continue;
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)ex1.getName()), new CSVFile.CSVField(ex1.getStudents().size()), new CSVFile.CSVField(p1.getPeriod().getIndex() + 1), new CSVFile.CSVField((Object)p1.getPeriod().getDayStr()), new CSVFile.CSVField((Object)p1.getPeriod().getTimeStr()), new CSVFile.CSVField((Object)ex2.getName()), new CSVFile.CSVField(ex2.getStudents().size()), new CSVFile.CSVField(p2.getPeriod().getIndex() + 1), new CSVFile.CSVField((Object)p2.getPeriod().getTimeStr()), new CSVFile.CSVField((Object)ex3.getName()), new CSVFile.CSVField(ex3.getStudents().size()), new CSVFile.CSVField(p3.getPeriod().getIndex() + 1), new CSVFile.CSVField((Object)p3.getPeriod().getTimeStr()), new CSVFile.CSVField(m2d), new CSVFile.CSVField((Object)df.format(100.0 * (double)m2d / (double)Math.min(Math.min(ex1.getStudents().size(), ex2.getStudents().size()), ex3.getStudents().size())))});
                }
            }
        }
        return csv;
    }
}

