/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.text.DecimalFormat;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import org.cpsolver.exam.criteria.StudentNotAvailableConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;

public class ExamStudentConflictsPerExam {
    private ExamModel iModel = null;

    public ExamStudentConflictsPerExam(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Exam"), new CSVFile.CSVField((Object)"Enrl"), new CSVFile.CSVField((Object)"Direct"), new CSVFile.CSVField((Object)"Direct [%]"), new CSVFile.CSVField((Object)"More-2-Day"), new CSVFile.CSVField((Object)"More-2-Day [%]"), new CSVFile.CSVField((Object)"Back-To-Back"), new CSVFile.CSVField((Object)"Back-To-Back [%]"), new CSVFile.CSVField((Object)"Dist Back-To-Back"), new CSVFile.CSVField((Object)"Dist Back-To-Back [%]")});
        DecimalFormat df = new DecimalFormat("0.0");
        for (Exam exam : this.iModel.variables()) {
            ExamPlacement placement = (ExamPlacement)assignment.getValue((Variable)exam);
            if (placement == null) continue;
            int dc = (int)this.iModel.getCriterion(StudentDirectConflicts.class).getValue(assignment, (Value)placement, null) + (int)this.iModel.getCriterion(StudentNotAvailableConflicts.class).getValue(assignment, (Value)placement, null);
            int btb = (int)this.iModel.getCriterion(StudentBackToBackConflicts.class).getValue(assignment, (Value)placement, null);
            int dbtb = (int)this.iModel.getCriterion(StudentDistanceBackToBackConflicts.class).getValue(assignment, (Value)placement, null);
            int m2d = (int)this.iModel.getCriterion(StudentMoreThan2ADayConflicts.class).getValue(assignment, (Value)placement, null);
            if (dc == 0 && m2d == 0 && btb == 0 && dbtb == 0) continue;
            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)exam.getName()), new CSVFile.CSVField(exam.getStudents().size()), new CSVFile.CSVField(dc), new CSVFile.CSVField((Object)df.format(100.0 * (double)dc / (double)exam.getStudents().size())), new CSVFile.CSVField(m2d), new CSVFile.CSVField((Object)df.format(100.0 * (double)m2d / (double)exam.getStudents().size())), new CSVFile.CSVField(btb), new CSVFile.CSVField((Object)df.format(100.0 * (double)btb / (double)exam.getStudents().size())), new CSVFile.CSVField(dbtb), new CSVFile.CSVField((Object)df.format(100.0 * (double)dbtb / (double)exam.getStudents().size()))});
        }
        return csv;
    }
}

