/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class SimpleNeighbour<V extends Variable<V, T>, T extends Value<V, T>>
implements Neighbour<V, T> {
    private V iVariable = null;
    private T iValue = null;
    private Set<T> iConflicts = null;

    public SimpleNeighbour(V variable, T value) {
        this.iVariable = variable;
        this.iValue = value;
    }

    public SimpleNeighbour(V variable, T value, Set<T> conflicts) {
        this.iVariable = variable;
        this.iValue = value;
        this.iConflicts = conflicts;
    }

    public V getVariable() {
        return this.iVariable;
    }

    public T getValue() {
        return this.iValue;
    }

    @Override
    public void assign(Assignment<V, T> assignment, long iteration) {
        if (this.iVariable == null) {
            return;
        }
        if (this.iConflicts != null) {
            for (Value conflict : this.iConflicts) {
                assignment.unassign(iteration, conflict.variable());
            }
        }
        if (this.iValue != null) {
            assignment.assign(iteration, this.iValue);
        } else {
            assignment.unassign(iteration, this.iVariable);
        }
    }

    @Override
    public double value(Assignment<V, T> assignment) {
        T old = assignment.getValue(this.iVariable);
        if (this.iValue != null && old == null && (this.iConflicts == null || this.iConflicts.isEmpty())) {
            return -1.0;
        }
        double val = (this.iValue == null ? 0.0 : ((Value)this.iValue).toDouble(assignment)) - (this.iVariable == null || old == null ? 0.0 : ((Value)old).toDouble(assignment));
        if (this.iConflicts != null) {
            for (Value conflict : this.iConflicts) {
                val -= conflict.toDouble(assignment);
            }
        }
        return val;
    }

    public String toString() {
        return ((Variable)this.iVariable).getName() + " := " + (this.iValue == null ? "null" : ((Value)this.iValue).getName());
    }

    @Override
    public Map<V, T> assignments() {
        HashMap ret = new HashMap();
        if (this.iVariable != null) {
            ret.put(this.iVariable, this.iValue);
        }
        if (this.iConflicts != null) {
            for (Value conflict : this.iConflicts) {
                ret.put(conflict.variable(), null);
            }
        }
        return ret;
    }
}

