/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.reservation.Reservation;

public class Config
extends AbstractClassWithContext<Request, Enrollment, ConfigContext>
implements CanInheritContext<Request, Enrollment, ConfigContext> {
    private long iId = -1L;
    private String iName = null;
    private Offering iOffering = null;
    private int iLimit = -1;
    private List<Subpart> iSubparts = new ArrayList<Subpart>();
    private Long iInstrMethodId;
    private String iInstrMethodName;
    private String iInstrMethodReference;
    private Double iTotalUnreservedSpace = null;
    List<Reservation> iReservations = null;
    List<Reservation> iConfigReservations = null;

    public Config(long id, int limit, String name, Offering offering) {
        this.iId = id;
        this.iLimit = limit;
        this.iName = name;
        this.iOffering = offering;
        this.iOffering.getConfigs().add(this);
    }

    public long getId() {
        return this.iId;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public String getName() {
        return this.iName;
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public List<Subpart> getSubparts() {
        return this.iSubparts;
    }

    public Long getInstructionalMethodId() {
        return this.iInstrMethodId;
    }

    public void setInstructionalMethodId(Long instrMethodId) {
        this.iInstrMethodId = instrMethodId;
    }

    public String getInstructionalMethodName() {
        return this.iInstrMethodName;
    }

    public void setInstructionalMethodName(String instrMethodName) {
        this.iInstrMethodName = instrMethodName;
    }

    public String getInstructionalMethodReference() {
        return this.iInstrMethodReference;
    }

    public void setInstructionalMethodReference(String instrMethodReference) {
        this.iInstrMethodReference = instrMethodReference;
    }

    public String toString() {
        return this.getName();
    }

    public double getMinPenalty() {
        double min = 0.0;
        for (Subpart subpart : this.getSubparts()) {
            min += subpart.getMinPenalty();
        }
        return min / (double)this.getSubparts().size();
    }

    public double getMaxPenalty() {
        double max = 0.0;
        for (Subpart subpart : this.getSubparts()) {
            max += subpart.getMinPenalty();
        }
        return max / (double)this.getSubparts().size();
    }

    public double getUnreservedSpace(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getConfigReservations()) {
                if (r.isExpired() || !(r.getLimit(this) < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = (double)this.getLimit() - ((ConfigContext)this.getContext(assignment)).getEnrollmentWeight(assignment, excludeRequest);
        for (Reservation r : this.getConfigReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit(this) < 0.0) {
                return 0.0;
            }
            double reserved = ((Reservation.ReservationContext)r.getContext(assignment)).getReservedAvailableSpace(assignment, this, excludeRequest);
            available -= Math.max(0.0, reserved);
        }
        return available;
    }

    public synchronized double getTotalUnreservedSpace() {
        if (this.iTotalUnreservedSpace == null) {
            this.iTotalUnreservedSpace = this.getTotalUnreservedSpaceNoCache();
        }
        return this.iTotalUnreservedSpace;
    }

    private double getTotalUnreservedSpaceNoCache() {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getConfigReservations()) {
                if (r.isExpired() || !(r.getLimit(this) < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = this.getLimit();
        double reserved = 0.0;
        double exclusive = 0.0;
        HashSet<Config> configs = new HashSet<Config>();
        block1: for (Reservation r : this.getConfigReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit(this) < 0.0) {
                return 0.0;
            }
            for (Config s : r.getConfigs()) {
                if (s.equals((Object)this)) continue;
                if (s.getLimit() < 0) continue block1;
                if (!configs.add(s)) continue;
                available += (double)s.getLimit();
            }
            reserved += r.getLimit(this);
            if (r.getConfigs().size() != 1) continue;
            exclusive += r.getLimit(this);
        }
        return Math.min(available - reserved, (double)this.getLimit() - exclusive);
    }

    public synchronized List<Reservation> getReservations() {
        if (this.iReservations == null) {
            this.iReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getOffering().getReservations()) {
                if (!r.getConfigs().isEmpty() && !r.getConfigs().contains((Object)this)) continue;
                this.iReservations.add(r);
            }
        }
        return this.iReservations;
    }

    public synchronized List<Reservation> getConfigReservations() {
        if (this.iConfigReservations == null) {
            this.iConfigReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getOffering().getReservations()) {
                if (r.getConfigs().isEmpty() || !r.getConfigs().contains((Object)this)) continue;
                this.iConfigReservations.add(r);
            }
        }
        return this.iConfigReservations;
    }

    public synchronized void clearReservationCache() {
        for (Subpart s : this.getSubparts()) {
            s.clearReservationCache();
        }
        this.iReservations = null;
        this.iConfigReservations = null;
        this.iTotalUnreservedSpace = null;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Config)) {
            return false;
        }
        return this.getId() == ((Config)((Object)o)).getId();
    }

    public int hashCode() {
        return Long.valueOf(this.getId()).hashCode();
    }

    public Model<Request, Enrollment> getModel() {
        return this.getOffering().getModel();
    }

    public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
        return ((ConfigContext)this.getContext(assignment)).getEnrollments();
    }

    public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((ConfigContext)this.getContext(assignment)).getEnrollmentWeight(assignment, excludeRequest);
    }

    public double getEnrollmentTotalWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((ConfigContext)this.getContext(assignment)).getEnrollmentTotalWeight(assignment, excludeRequest);
    }

    public double getMaxEnrollmentWeight(Assignment<Request, Enrollment> assignment) {
        return ((ConfigContext)this.getContext(assignment)).getMaxEnrollmentWeight();
    }

    public double getMinEnrollmentWeight(Assignment<Request, Enrollment> assignment) {
        return ((ConfigContext)this.getContext(assignment)).getMinEnrollmentWeight();
    }

    public ConfigContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new ConfigContext(assignment);
    }

    public ConfigContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, ConfigContext parentContext) {
        return new ConfigContext(parentContext);
    }

    public boolean hasCreditValue() {
        for (Subpart subpart : this.getSubparts()) {
            if (!subpart.hasCreditValue()) continue;
            return true;
        }
        return false;
    }

    public Float getCreditValue() {
        float credit = 0.0f;
        boolean hasCredit = false;
        for (Subpart subpart : this.getSubparts()) {
            if (!subpart.hasCreditValue()) continue;
            hasCredit = true;
            credit += subpart.getCreditValue().floatValue();
        }
        return hasCredit ? Float.valueOf(credit) : null;
    }

    public int getNrOnline() {
        int online = 0;
        for (Subpart subpart : this.getSubparts()) {
            if (!subpart.isOnline()) continue;
            ++online;
        }
        return online;
    }

    public int getNrArrHours() {
        int arrHrs = 0;
        for (Subpart subpart : this.getSubparts()) {
            if (subpart.hasTime()) continue;
            ++arrHrs;
        }
        return arrHrs;
    }

    public int getNrPast() {
        int past = 0;
        for (Subpart subpart : this.getSubparts()) {
            if (!subpart.isPast()) continue;
            ++past;
        }
        return past;
    }

    public class ConfigContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private double iEnrollmentWeight = 0.0;
        private double iEnrollmentTotalWeight = 0.0;
        private double iMaxEnrollmentWeight = 0.0;
        private double iMinEnrollmentWeight = 0.0;
        private Set<Enrollment> iEnrollments = null;
        private boolean iReadOnly = false;

        public ConfigContext(Assignment<Request, Enrollment> assignment) {
            this.iEnrollments = new HashSet<Enrollment>();
            for (Course course : Config.this.getOffering().getCourses()) {
                for (CourseRequest request : course.getRequests()) {
                    Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                    if (enrollment == null || !Config.this.equals((Object)enrollment.getConfig())) continue;
                    this.assigned(assignment, enrollment);
                }
            }
        }

        public ConfigContext(ConfigContext parent) {
            this.iEnrollmentWeight = parent.iEnrollmentWeight;
            this.iEnrollmentTotalWeight = parent.iEnrollmentTotalWeight;
            this.iMaxEnrollmentWeight = parent.iMaxEnrollmentWeight;
            this.iMinEnrollmentWeight = parent.iMinEnrollmentWeight;
            this.iEnrollments = parent.iEnrollments;
            this.iReadOnly = true;
        }

        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.isEmpty()) {
                this.iMinEnrollmentWeight = this.iMaxEnrollmentWeight = enrollment.getRequest().getWeight();
            } else {
                this.iMaxEnrollmentWeight = Math.max(this.iMaxEnrollmentWeight, enrollment.getRequest().getWeight());
                this.iMinEnrollmentWeight = Math.min(this.iMinEnrollmentWeight, enrollment.getRequest().getWeight());
            }
            if (this.iEnrollments.add(enrollment)) {
                this.iEnrollmentTotalWeight += enrollment.getRequest().getWeight();
                if (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit()) {
                    this.iEnrollmentWeight += enrollment.getRequest().getWeight();
                }
            }
        }

        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.remove((Object)enrollment)) {
                this.iEnrollmentTotalWeight -= enrollment.getRequest().getWeight();
                if (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit()) {
                    this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
                }
            }
            if (this.iEnrollments.isEmpty()) {
                this.iMaxEnrollmentWeight = 0.0;
                this.iMinEnrollmentWeight = 0.0;
            } else if (this.iMinEnrollmentWeight != this.iMaxEnrollmentWeight) {
                if (this.iMinEnrollmentWeight == enrollment.getRequest().getWeight()) {
                    double newMinEnrollmentWeight = Double.MAX_VALUE;
                    for (Enrollment e : this.iEnrollments) {
                        if (e.getRequest().getWeight() == this.iMinEnrollmentWeight) {
                            newMinEnrollmentWeight = this.iMinEnrollmentWeight;
                            break;
                        }
                        newMinEnrollmentWeight = Math.min(newMinEnrollmentWeight, e.getRequest().getWeight());
                    }
                    this.iMinEnrollmentWeight = newMinEnrollmentWeight;
                }
                if (this.iMaxEnrollmentWeight == enrollment.getRequest().getWeight()) {
                    double newMaxEnrollmentWeight = Double.MIN_VALUE;
                    for (Enrollment e : this.iEnrollments) {
                        if (e.getRequest().getWeight() == this.iMaxEnrollmentWeight) {
                            newMaxEnrollmentWeight = this.iMaxEnrollmentWeight;
                            break;
                        }
                        newMaxEnrollmentWeight = Math.max(newMaxEnrollmentWeight, e.getRequest().getWeight());
                    }
                    this.iMaxEnrollmentWeight = newMaxEnrollmentWeight;
                }
            }
        }

        public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            Enrollment enrollment;
            double weight = this.iEnrollmentWeight;
            if (excludeRequest != null && (enrollment = (Enrollment)assignment.getValue((Variable)excludeRequest)) != null && this.iEnrollments.contains((Object)enrollment) && (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit())) {
                weight -= excludeRequest.getWeight();
            }
            return weight;
        }

        public double getEnrollmentTotalWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            Enrollment enrollment;
            double weight = this.iEnrollmentTotalWeight;
            if (excludeRequest != null && (enrollment = (Enrollment)assignment.getValue((Variable)excludeRequest)) != null && this.iEnrollments.contains((Object)enrollment)) {
                weight -= excludeRequest.getWeight();
            }
            return weight;
        }

        public Set<Enrollment> getEnrollments() {
            return this.iEnrollments;
        }

        public double getMaxEnrollmentWeight() {
            return this.iMaxEnrollmentWeight;
        }

        public double getMinEnrollmentWeight() {
            return this.iMinEnrollmentWeight;
        }
    }
}

