/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.heuristics.RandomizedBacktrackNeighbourSelection;
import org.cpsolver.studentsct.heuristics.selection.BacktrackSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class CriticalBacktrackSelection
extends BacktrackSelection {
    private Request.RequestPriority iPriority;

    public CriticalBacktrackSelection(DataProperties properties, Request.RequestPriority priority) {
        super(properties);
        this.iPriority = priority;
        this.iIncludeAssignedRequests = properties.getPropertyBoolean("Neighbour.IncludeCriticalAssignedRequests", this.iIncludeAssignedRequests);
    }

    public CriticalBacktrackSelection(DataProperties properties) {
        this(properties, Request.RequestPriority.Critical);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList<Request> variables = new ArrayList<Request>();
        for (Request r : this.iIncludeAssignedRequests ? solver.currentSolution().getModel().variables() : solver.currentSolution().getModel().unassignedVariables(solver.currentSolution().getAssignment())) {
            if (!this.iPriority.isCritical(r)) continue;
            variables.add(r);
        }
        Collections.shuffle(variables);
        Collections.sort(variables, this.iRequestComparator);
        this.iRequests = new LinkedList(variables);
        if (this.iRBtNSel == null) {
            try {
                this.iRBtNSel = new RandomizedBacktrackNeighbourSelection(solver.getProperties());
                this.iRBtNSel.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance((Object)solver.currentSolution().getModel()).setPhase(this.iPriority.name() + " Backtracking" + (this.iFilter == null ? "" : " (" + this.iFilter.getName().toLowerCase() + " students)") + "...", (long)variables.size());
    }
}

