/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.check;

import java.text.DecimalFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class CourseLimitCheck {
    private static Logger sLog = LogManager.getLogger(CourseLimitCheck.class);
    private static DecimalFormat sDF = new DecimalFormat("0.0");
    private StudentSectioningModel iModel;
    private CSVFile iCSVFile = null;
    private boolean iFixUnlimited = false;
    private boolean iUpZeroLimits = false;
    private boolean iUpNonZeroLimits = false;

    public CourseLimitCheck(StudentSectioningModel model) {
        this.iModel = model;
        this.iCSVFile = new CSVFile();
        this.iCSVFile.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Limit"), new CSVFile.CSVField((Object)"Students"), new CSVFile.CSVField((Object)"Real"), new CSVFile.CSVField((Object)"Last-like")});
        this.iFixUnlimited = model.getProperties().getPropertyBoolean("CourseLimitCheck.FixUnlimited", this.iFixUnlimited);
        this.iUpZeroLimits = model.getProperties().getPropertyBoolean("CourseLimitCheck.UpZeroLimits", this.iUpZeroLimits);
        this.iUpNonZeroLimits = model.getProperties().getPropertyBoolean("CourseLimitCheck.UpNonZeroLimits", this.iUpNonZeroLimits);
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public CSVFile getCSVFile() {
        return this.iCSVFile;
    }

    /*
     * Could not resolve type clashes
     */
    public boolean check() {
        sLog.info("Checking for course limits...");
        boolean ret = true;
        for (Offering offering : this.getModel().getOfferings()) {
            Object config3;
            if (offering.isDummy()) continue;
            boolean hasUnlimitedSection = false;
            if (this.iFixUnlimited) {
                for (Config config2 : offering.getConfigs()) {
                    for (Subpart subpart : config2.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            if (section.getLimit() >= 0) continue;
                            hasUnlimitedSection = true;
                        }
                    }
                }
            }
            int offeringLimit = 0;
            int nrStudents = 0;
            for (Course course : offering.getCourses()) {
                if (course.getLimit() < 0) {
                    offeringLimit = -1;
                    continue;
                }
                if (this.iFixUnlimited && hasUnlimitedSection) {
                    sLog.info("Course " + (Object)((Object)course) + " made unlimited.");
                    course.setLimit(-1);
                    offeringLimit = -1;
                    continue;
                }
                double total = 0.0;
                double lastLike = 0.0;
                double real = 0.0;
                for (Request request : this.getModel().variables()) {
                    if (!(request instanceof CourseRequest) || !((CourseRequest)request).getCourses().contains((Object)course)) continue;
                    total += request.getWeight();
                    if (request.getStudent().isDummy()) {
                        lastLike += request.getWeight();
                        continue;
                    }
                    real += request.getWeight();
                }
                nrStudents = (int)((long)nrStudents + Math.round(total));
                offeringLimit += course.getLimit();
                if (Math.round(total) <= (long)course.getLimit()) continue;
                sLog.error("Course " + (Object)((Object)course) + " is requested by " + sDF.format(total) + " students, but its limit is only " + course.getLimit());
                ret = false;
                this.iCSVFile.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)course.getName()), new CSVFile.CSVField(course.getLimit()), new CSVFile.CSVField(total), new CSVFile.CSVField(real), new CSVFile.CSVField(lastLike)});
                if (this.iUpZeroLimits && course.getLimit() == 0) {
                    int oldLimit = course.getLimit();
                    course.setLimit((int)Math.round(total));
                    sLog.info("  -- limit of course " + (Object)((Object)course) + " increased to " + course.getLimit() + " (was " + oldLimit + ")");
                    continue;
                }
                if (!this.iUpNonZeroLimits || course.getLimit() <= 0) continue;
                int oldLimit = course.getLimit();
                course.setLimit((int)Math.round(total));
                sLog.info("  -- limit of course " + (Object)((Object)course) + " increased to " + course.getLimit() + " (was " + oldLimit + ")");
            }
            if (this.iUpZeroLimits && offeringLimit == 0 && nrStudents > 0) {
                for (Object config3 : offering.getConfigs()) {
                    for (Subpart subpart : ((Config)((Object)config3)).getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            int oldLimit = section.getLimit();
                            section.setLimit(Math.max(section.getLimit(), (int)Math.ceil(nrStudents / subpart.getSections().size())));
                            sLog.info("    -- limit of section " + section + " increased to " + section.getLimit() + " (was " + oldLimit + ")");
                        }
                    }
                }
            } else if (this.iUpNonZeroLimits && offeringLimit >= 0 && nrStudents > offeringLimit) {
                double fact = (double)nrStudents / (double)offeringLimit;
                for (Config config4 : offering.getConfigs()) {
                    for (Subpart subpart : config4.getSubparts()) {
                        for (Object section : subpart.getSections()) {
                            int oldLimit = ((Section)section).getLimit();
                            ((Section)section).setLimit((int)Math.ceil(fact * (double)((Section)section).getLimit()));
                            sLog.info("    -- limit of section " + section + " increased to " + ((Section)section).getLimit() + " (was " + oldLimit + ")");
                        }
                    }
                }
            }
            if (offeringLimit < 0) continue;
            int totalSectionLimit = 0;
            config3 = offering.getConfigs().iterator();
            while (config3.hasNext()) {
                Config config5 = (Config)((Object)config3.next());
                int configLimit = -1;
                for (Subpart subpart : config5.getSubparts()) {
                    Object section;
                    int subpartLimit = 0;
                    section = subpart.getSections().iterator();
                    while (section.hasNext()) {
                        Section section2 = section.next();
                        subpartLimit += section2.getLimit();
                    }
                    if (configLimit < 0) {
                        configLimit = subpartLimit;
                        continue;
                    }
                    configLimit = Math.min(configLimit, subpartLimit);
                }
                totalSectionLimit += configLimit;
            }
            if (totalSectionLimit >= offeringLimit) continue;
            sLog.error("Offering limit of " + offering + " is " + offeringLimit + ", but total section limit is only " + totalSectionLimit);
            if (this.iUpZeroLimits && totalSectionLimit == 0) {
                config3 = offering.getConfigs().iterator();
                while (config3.hasNext()) {
                    Config config6 = (Config)((Object)config3.next());
                    for (Subpart subpart : config6.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            int oldLimit = section.getLimit();
                            section.setLimit(Math.max(section.getLimit(), (int)Math.ceil((double)offeringLimit / (double)subpart.getSections().size())));
                            sLog.info("    -- limit of section " + section + " increased to " + section.getLimit() + " (was " + oldLimit + ")");
                        }
                    }
                }
                continue;
            }
            if (!this.iUpNonZeroLimits || totalSectionLimit <= 0) continue;
            double fact = (double)offeringLimit / (double)totalSectionLimit;
            for (Config config7 : offering.getConfigs()) {
                for (Subpart subpart : config7.getSubparts()) {
                    for (Section section2 : subpart.getSections()) {
                        int oldLimit = section2.getLimit();
                        section2.setLimit((int)Math.ceil(fact * (double)section2.getLimit()));
                        sLog.info("    -- limit of section " + section2 + " increased to " + section2.getLimit() + " (was " + oldLimit + ")");
                    }
                }
            }
        }
        return ret;
    }
}

